#!/bin/bash

   #################################################################
   #                                                               #
   #             tlbardelljr VM services installer                 #
   #           Copyright (C) 2023 Terry Bardell Jr                 #
   #       Licensed under the GNU General Public License 3.0       #
   #                                                               #
   #                                                               #
   #                                                               #
   #################################################################
   
my_options=(   "OpenVPN" "DHCP"  "DHCP-config-single" "Icecast" "AdGuard" "Plex"  "Shinobi" "Apache_web" "MariaDB" "PHP_Install_7_4")
preselection=( "false"   "false" "false"              "false"   "false"   "false" "false"   "false"      "false"   "false"          )
installer_name="tlbardelljr network VM installer"
sdoutColor=250
progressBarColorFG=226
progressBarColorBG=242
headerColorFG=255
headerColorBG=242

export terminal=$(tty)

command -v apt > /dev/null && package_manager="apt-get"
command -v yum > /dev/null && package_manager="yum"
command -v zypper > /dev/null && package_manager="zypper"

Update () {
	"$package_manager" update -y & progress_bar $!;
}
 
OpenVPN () {
	case "$package_manager" in

	apt-get) 
		curl -O https://raw.githubusercontent.com/angristan/openvpn-install/master/openvpn-install.sh & progress_bar $!;
		chmod -R 777 openvpn-install.sh & progress_bar $!;
		./openvpn-install.sh < $terminal & progress_bar $!;
		echo ;
		echo '---------------------------------------------------------------------------------------';
		echo 'OpenVPN server should be running.                                                      ';
		echo '---------------------------------------------------------------------------------------';
		echo ;
	    	;;
	yum) 
		curl -O https://raw.githubusercontent.com/angristan/openvpn-install/master/openvpn-install.sh & progress_bar $!;
		chmod -R 777 openvpn-install.sh & progress_bar $!;
		./openvpn-install.sh < $terminal & progress_bar $!;
		systemctl enable openvpn-server@server
		systemctl restart openvpn-server@server
		echo ;
		echo '---------------------------------------------------------------------------------------';
		echo 'OpenVPN server should be running.                                                      ';
		echo '---------------------------------------------------------------------------------------';
		echo ;
	    	;;
	zypper)  
		curl -O https://raw.githubusercontent.com/angristan/openvpn-install/master/openvpn-install.sh & progress_bar $!;
		chmod -R 777 openvpn-install.sh & progress_bar $!;
		sed -i '/arch-release/c\elif [[ -e /etc/os-release ]]; then' openvpn-install.sh
		sed -i '/OS=arch/c\OS=suse' openvpn-install.sh
		./openvpn-install.sh < $terminal & progress_bar $!;
		systemctl enable openvpn@server
		systemctl start openvpn@server
		echo ;
		echo '---------------------------------------------------------------------------------------';
		echo 'OpenVPN server should be running.                                                      ';
		echo '---------------------------------------------------------------------------------------';
		echo ;
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
	

}

DHCP () {
	case "$package_manager" in

	apt-get) 
		"$package_manager" -y install isc-dhcp-server & progress_bar $!;
	    	;;
	yum) 
		"$package_manager" -y install dhcp-server & progress_bar $!;
	    	;;
	zypper)  
		"$package_manager" -n install dhcp-server & progress_bar $!;
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

DHCP-config-single () {
	case "$package_manager" in

	apt-get) 
		isc_dhcp_file='/etc/default/isc-dhcp-server'
		dhcpd_file='/etc/dhcp/dhcpd.conf'
		main_interface=$(ip route get 8.8.8.8 | awk -- '{printf $5}');
		
		sed -i '/INTERFACESv4/c\INTERFACESv4="'$main_interface'"' $isc_dhcp_file
		
		echo Enter network IP. This will end in 0. Use prefix for full CIDR. For example 192.168.0.0/16
		read -e network < $terminal  
		echo Enter DNS IP. If multiple seperate with comma. For example 8.8.8.8 , 1.1.1.1
		read -e DNS < $terminal  
		echo Enter DHCP range for pool with space between addresses. For example 192.168.0.50 192.168.0.250
		read -e range < $terminal      

		networkIP=$(echo $network | cut -d'/' -f1)
		mask=$(echo $network | cut -d'/' -f2)

		# assume CIDR like /24, convert to mask
		if [[ $((mask)) -lt 8 ]]; then
		maskarr="$((256-2**(8-mask))) 0 0 0"
		elif  [[ $((mask)) -lt 16 ]]; then
		maskarr="255 $((256-2**(16-mask))) 0 0"
		elif  [[ $((mask)) -lt 24 ]]; then
		maskarr="255 255 $((256-2**(24-mask))) 0"
		elif [[ $((mask)) -lt 32 ]]; then
		maskarr="255 255 255 $((256-2**(32-mask)))"
		elif [[ ${mask} == 32 ]]; then
		maskarr="255 255 255 255"
		fi

		networkSub=$maskarr

		int2ip()
		{
		    local ui32=$1; shift
		    local ip n
		    for n in 1 2 3 4; do
			ip=$((ui32 & 0xff))${ip:+.}$ip
			ui32=$((ui32 >> 8))
		    done
		    echo $ip
		}

		ip2int()
		{
		    local a b c d
		    { IFS=. read a b c d; } <<< $1
		    #echo $(((((((a << 8) | b) << 8) | c) << 8) | d))
		    echo $((a * 256 ** 3 + b * 256 ** 2 + c * 256 + d))
		}

		broadcast()
		{
		    local addr=$(ip2int $1); shift
		    local mask=$((0xffffffff << (32 -$1))); shift
		    int2ip $((addr | ~mask))
		}
		broadcastIP=$(broadcast $networkIP $mask)

		gateway=${networkIP%?}1
		networkSub=${networkSub// /.}
		broadcastIP=${broadcastIP// /.}

		echo '#' | tee $dhcpd_file;
		echo '# /etc/dhcpd.conf for primary DHCP server' | tee -a $dhcpd_file;
		echo '#' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'authoritative;' | tee -a $dhcpd_file;
		echo 'ddns-update-style none;' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo '#failover' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'subnet '$networkIP' netmask '$networkSub' {' | tee -a $dhcpd_file;
		echo '            option subnet-mask '$networkSub';' | tee -a $dhcpd_file;
		echo '            option broadcast-address '$broadcastIP';' | tee -a $dhcpd_file;
		echo '            option routers '$gateway';' | tee -a $dhcpd_file;
		echo '            option domain-name-servers '$DNS';' | tee -a $dhcpd_file;
		echo '            pool {' | tee -a $dhcpd_file;
		echo '                        max-lease-time 600;' | tee -a $dhcpd_file;
		echo '                        range '$range';' | tee -a $dhcpd_file;
		echo '                        }' | tee -a $dhcpd_file;
		echo '            }' | tee -a $dhcpd_file;
		
		systemctl restart isc-dhcp-server;
                systemctl status isc-dhcp-server;
	    	;;
	yum) 
		isc_dhcp_file='/etc/default/isc-dhcp-server'
		dhcpd_file='/etc/dhcp/dhcpd.conf'
		main_interface=$(ip route get 8.8.8.8 | awk -- '{printf $5}');
		
		#sed -i '/INTERFACESv4/c\INTERFACESv4="'$main_interface'"' $isc_dhcp_file
		
		echo Enter network IP. This will end in 0. Use prefix for full CIDR. For example 192.168.0.0/16
		read -e network < $terminal  
		echo Enter DNS IP. If multiple seperate with comma. For example 8.8.8.8 , 1.1.1.1
		read -e DNS < $terminal  
		echo Enter DHCP range for pool with space between addresses. For example 192.168.0.50 192.168.0.250
		read -e range < $terminal      

		networkIP=$(echo $network | cut -d'/' -f1)
		mask=$(echo $network | cut -d'/' -f2)

		# assume CIDR like /24, convert to mask
		if [[ $((mask)) -lt 8 ]]; then
		maskarr="$((256-2**(8-mask))) 0 0 0"
		elif  [[ $((mask)) -lt 16 ]]; then
		maskarr="255 $((256-2**(16-mask))) 0 0"
		elif  [[ $((mask)) -lt 24 ]]; then
		maskarr="255 255 $((256-2**(24-mask))) 0"
		elif [[ $((mask)) -lt 32 ]]; then
		maskarr="255 255 255 $((256-2**(32-mask)))"
		elif [[ ${mask} == 32 ]]; then
		maskarr="255 255 255 255"
		fi

		networkSub=$maskarr

		int2ip()
		{
		    local ui32=$1; shift
		    local ip n
		    for n in 1 2 3 4; do
			ip=$((ui32 & 0xff))${ip:+.}$ip
			ui32=$((ui32 >> 8))
		    done
		    echo $ip
		}

		ip2int()
		{
		    local a b c d
		    { IFS=. read a b c d; } <<< $1
		    #echo $(((((((a << 8) | b) << 8) | c) << 8) | d))
		    echo $((a * 256 ** 3 + b * 256 ** 2 + c * 256 + d))
		}

		broadcast()
		{
		    local addr=$(ip2int $1); shift
		    local mask=$((0xffffffff << (32 -$1))); shift
		    int2ip $((addr | ~mask))
		}
		broadcastIP=$(broadcast $networkIP $mask)

		gateway=${networkIP%?}1
		networkSub=${networkSub// /.}
		broadcastIP=${broadcastIP// /.}

		echo '#' | tee $dhcpd_file;
		echo '# /etc/dhcpd.conf for primary DHCP server' | tee -a $dhcpd_file;
		echo '#' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'authoritative;' | tee -a $dhcpd_file;
		echo 'ddns-update-style none;' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo '#failover' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'subnet '$networkIP' netmask '$networkSub' {' | tee -a $dhcpd_file;
		echo '            option subnet-mask '$networkSub';' | tee -a $dhcpd_file;
		echo '            option broadcast-address '$broadcastIP';' | tee -a $dhcpd_file;
		echo '            option routers '$gateway';' | tee -a $dhcpd_file;
		echo '            option domain-name-servers '$DNS';' | tee -a $dhcpd_file;
		echo '            pool {' | tee -a $dhcpd_file;
		echo '                        max-lease-time 600;' | tee -a $dhcpd_file;
		echo '                        range '$range';' | tee -a $dhcpd_file;
		echo '                        }' | tee -a $dhcpd_file;
		echo '            }' | tee -a $dhcpd_file;
		systemctl enable dhcpd;
		systemctl restart dhcpd;
                systemctl status dhcpd;
	    	;;
	zypper)  
		isc_dhcp_file='/etc/sysconfig/dhcpd'
		dhcpd_file='/etc/dhcpd.conf'
		main_interface=$(ip route get 8.8.8.8 | awk -- '{printf $5}');
		
		sed -i '/DHCPD_INTERFACE/c\DHCPD_INTERFACE="'$main_interface'"' $isc_dhcp_file
		
		echo Enter network IP. This will end in 0. Use prefix for full CIDR. For example 192.168.0.0/16
		read -e network < $terminal  
		echo Enter DNS IP. If multiple seperate with comma. For example 8.8.8.8 , 1.1.1.1
		read -e DNS < $terminal  
		echo Enter DHCP range for pool with space between addresses. For example 192.168.0.50 192.168.0.250
		read -e range < $terminal      

		networkIP=$(echo $network | cut -d'/' -f1)
		mask=$(echo $network | cut -d'/' -f2)

		# assume CIDR like /24, convert to mask
		if [[ $((mask)) -lt 8 ]]; then
		maskarr="$((256-2**(8-mask))) 0 0 0"
		elif  [[ $((mask)) -lt 16 ]]; then
		maskarr="255 $((256-2**(16-mask))) 0 0"
		elif  [[ $((mask)) -lt 24 ]]; then
		maskarr="255 255 $((256-2**(24-mask))) 0"
		elif [[ $((mask)) -lt 32 ]]; then
		maskarr="255 255 255 $((256-2**(32-mask)))"
		elif [[ ${mask} == 32 ]]; then
		maskarr="255 255 255 255"
		fi

		networkSub=$maskarr

		int2ip()
		{
		    local ui32=$1; shift
		    local ip n
		    for n in 1 2 3 4; do
			ip=$((ui32 & 0xff))${ip:+.}$ip
			ui32=$((ui32 >> 8))
		    done
		    echo $ip
		}

		ip2int()
		{
		    local a b c d
		    { IFS=. read a b c d; } <<< $1
		    #echo $(((((((a << 8) | b) << 8) | c) << 8) | d))
		    echo $((a * 256 ** 3 + b * 256 ** 2 + c * 256 + d))
		}

		broadcast()
		{
		    local addr=$(ip2int $1); shift
		    local mask=$((0xffffffff << (32 -$1))); shift
		    int2ip $((addr | ~mask))
		}
		broadcastIP=$(broadcast $networkIP $mask)

		gateway=${networkIP%?}1
		networkSub=${networkSub// /.}
		broadcastIP=${broadcastIP// /.}

		echo '#' | tee $dhcpd_file;
		echo '# /etc/dhcpd.conf for primary DHCP server' | tee -a $dhcpd_file;
		echo '#' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'authoritative;' | tee -a $dhcpd_file;
		echo 'ddns-update-style none;' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo '#failover' | tee -a $dhcpd_file;
		echo '' | tee -a $dhcpd_file;
		echo 'subnet '$networkIP' netmask '$networkSub' {' | tee -a $dhcpd_file;
		echo '            option subnet-mask '$networkSub';' | tee -a $dhcpd_file;
		echo '            option broadcast-address '$broadcastIP';' | tee -a $dhcpd_file;
		echo '            option routers '$gateway';' | tee -a $dhcpd_file;
		echo '            option domain-name-servers '$DNS';' | tee -a $dhcpd_file;
		echo '            pool {' | tee -a $dhcpd_file;
		echo '                        max-lease-time 600;' | tee -a $dhcpd_file;
		echo '                        range '$range';' | tee -a $dhcpd_file;
		echo '                        }' | tee -a $dhcpd_file;
		echo '            }' | tee -a $dhcpd_file;
		systemctl enable dhcpd;
		systemctl restart dhcpd;
                systemctl status dhcpd;
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}


Icecast () {
	case "$package_manager" in

	apt-get) 
		"$package_manager" -y install icecast2 & progress_bar $!;
		;;
	yum) 
		"$package_manager" -y install icecast & progress_bar $!;
		sudo systemctl --now enable icecast;
	    	;;
	zypper)  
		"$package_manager" addrepo https://download.opensuse.org/repositories/home:lemmy04/15.5/home:lemmy04.repo & progress_bar $!;
		"$package_manager" refresh & progress_bar $!;
		"$package_manager" install icecast & progress_bar $!;
		sudo systemctl --now enable icecast;
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

AdGuard () {
	case "$package_manager" in

	apt-get) 
		curl -s -S -L https://raw.githubusercontent.com/AdguardTeam/AdGuardHome/master/scripts/install.sh | sh -s -- -v & progress_bar $!;
		echo "http://xxx.xxx.xxx.xxx:3000"
		;;
	yum) 
		curl -s -S -L https://raw.githubusercontent.com/AdguardTeam/AdGuardHome/master/scripts/install.sh | sh -s -- -v & progress_bar $!;
		echo "http://xxx.xxx.xxx.xxx:3000"
	    	;;
	zypper)  
		curl -s -S -L https://raw.githubusercontent.com/AdguardTeam/AdGuardHome/master/scripts/install.sh | sh -s -- -v & progress_bar $!;
		echo "http://xxx.xxx.xxx.xxx:3000"
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

Plex () {
	case "$package_manager" in

	apt-get) 
		"$package_manager" install apt-transport-https curl -y & progress_bar $!;
                curl https://downloads.plex.tv/plex-keys/PlexSign.key | apt-key add - & progress_bar $!;
                echo deb https://downloads.plex.tv/repo/deb public main | tee /etc/apt/sources.list.d/plexmediaserver.list & progress_bar $!;
                "$package_manager" update & progress_bar $!;
                "$package_manager" install plexmediaserver & progress_bar $!;
		;;
	yum) 
		"$package_manager" install apt-transport-https curl -y & progress_bar $!;
		echo '[Plexrepo]' | tee /etc/yum.repos.d/plex.repo;
		echo 'name=plexrepo' | tee -a /etc/yum.repos.d/plex.repo;
		echo 'baseurl=https://downloads.plex.tv/repo/rpm/\$basearch/' | tee -a /etc/yum.repos.d/plex.repo;
		echo 'enabled=1' | tee -a /etc/yum.repos.d/plex.repo;
		echo 'gpgkey=https://downloads.plex.tv/plex-keys/PlexSign.key' | tee -a /etc/yum.repos.d/plex.repo;
		echo 'gpgcheck=1' | tee -a /etc/yum.repos.d/plex.repo;
		sudo dnf install plexmediaserver -y  & progress_bar $!;
                echo "xxx.xxx.xxx.xxx:32400/manage"
	    	;;
	zypper)  
		"$package_manager" install apt-transport-https curl -y & progress_bar $!;
		echo '[Plexrepo]' | tee /etc/zypp/repos.d/plex.repo;
		echo 'name=plexrepo' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'baseurl=https://downloads.plex.tv/repo/rpm/$basearch' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'enabled=1' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'autorefresh=1' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'type=rpm-md' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'gpgkey=https://downloads.plex.tv/plex-keys/PlexSign.key' | tee -a /etc/zypp/repos.d/plex.repo;
		echo 'gpgcheck=1' | tee -a /etc/zypp/repos.d/plex.repo;
		zypper update -y
		sudo "$package_manager" install plexmediaserver -y  & progress_bar $!;
                echo "xxx.xxx.xxx.xxx:32400/manage"
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

Shinobi () {
	case "$package_manager" in

	apt-get) 
		sh <(curl -s https://cdn.shinobi.video/installers/shinobi-install.sh)
		;;
	yum) 
		sh <(curl -s https://cdn.shinobi.video/installers/shinobi-install.sh)
	    	;;
	zypper)  
		#zypper install nodejs
		#pm2 startup
		#sh <(curl -s https://cdn.shinobi.video/installers/shinobi-install.sh)
		echo "Shinobi not supported on OpenSuse"
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

Apache_web () {
	case "$package_manager" in

	apt-get) 
		"$package_manager" -y install apache2 & progress_bar $!;
		systemctl enable apache2
		systemctl start apache2
		#systemctl status apache2
	    	;;
	yum) 
		"$package_manager" -y install httpd & progress_bar $!;
		systemctl start httpd
		#systemctl status httpd
	    	;;
	zypper)  
		"$package_manager" install --no-confirm  apache2 & progress_bar $!;
		systemctl restart apache2
		#systemctl status apache2
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

MariaDB () {
	case "$package_manager" in

	apt-get) 
		"$package_manager" -y install mariadb-server & progress_bar $!;
		systemctl restart mariadb
		systemctl status mariadb
		mariadb-secure-installation
	    	;;
	yum) 
		dnf module -y install mariadb:10.9/server & progress_bar $!;
		systemctl enable --now mariadb
		mariadb-secure-installation
	    	;;
	zypper)  
		#https://mariadb.com/kb/en/installing-mariadb-with-zypper/
		zypper addrepo https://download.opensuse.org/repositories/server:database/15.5/server:database.repo
		zypper refresh
		zypper install mariadb & progress_bar $!;
		systemctl start mariadb
		mariadb-secure-installation
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}

PHP_Install_7_4 () {
	case "$package_manager" in

	apt-get) 
		if (( $distro == "Debian GNU/Linux-12" )); then
	   		"$package_manager" -y install apt-transport-https lsb-release ca-certificates wget
			wget -O /etc/apt/trusted.gpg.d/php.gpg https://packages.sury.org/php/apt.gpg
			echo "deb https://packages.sury.org/php/ $(lsb_release -sc) main" | sudo tee /etc/apt/sources.list.d/php.list
			"$package_manager" update 
			"$package_manager" -y install php7.4 & progress_bar $!;
			"$package_manager" -y install php7.4-common & progress_bar $!; 
			"$package_manager" -y install php7.4-curl & progress_bar $!;
			"$package_manager" -y install php7.4-gd & progress_bar $!;
			"$package_manager" -y install php7.4-gmp & progress_bar $!;
			"$package_manager" -y install php7.4-bcmath & progress_bar $!;
			"$package_manager" -y install php7.4-imap & progress_bar $!;
			"$package_manager" -y install php7.4-intl & progress_bar $!; 
			"$package_manager" -y install php7.4-json & progress_bar $!;
			"$package_manager" -y install php7.4-mbstring & progress_bar $!;
			"$package_manager" -y install php7.4-mysql & progress_bar $!;
			"$package_manager" -y install php7.4-ssh2 & progress_bar $!;
			"$package_manager" -y install php7.4-xml & progress_bar $!;
			"$package_manager" -y install php7.4-zip & progress_bar $!;
			"$package_manager" -y install php7.4-apcu & progress_bar $!;
			"$package_manager" -y install php7.4-redis & progress_bar $!;
			"$package_manager" -y install php7.4-ldap & progress_bar $!;
			"$package_manager" -y install php7.4-phpseclib & progress_bar $!;
		elif (( $distro == "Ubuntu-22.04" )); then
		
		fi
		
	    	;;
	yum) 
		"$package_manager" -y install php7.4 & progress_bar $!;
		"$package_manager" -y install php7.4-common & progress_bar $!; 
		"$package_manager" -y install php7.4-curl & progress_bar $!;
		"$package_manager" -y install php7.4-gd & progress_bar $!;
		"$package_manager" -y install php7.4-gmp & progress_bar $!;
		"$package_manager" -y install php7.4-bcmath & progress_bar $!;
		"$package_manager" -y install php7.4-imap & progress_bar $!;
		"$package_manager" -y install php7.4-intl & progress_bar $!; 
		"$package_manager" -y install php7.4-json & progress_bar $!;
		"$package_manager" -y install php7.4-mbstring & progress_bar $!;
		"$package_manager" -y install php7.4-mysql & progress_bar $!;
		"$package_manager" -y install php7.4-ssh2 & progress_bar $!;
		"$package_manager" -y install php7.4-xml & progress_bar $!;
		"$package_manager" -y install php7.4-zip & progress_bar $!;
		"$package_manager" -y install php7.4-apcu & progress_bar $!;
		"$package_manager" -y install php7.4-redis & progress_bar $!;
		"$package_manager" -y install php7.4-ldap & progress_bar $!;
		"$package_manager" -y install php7.4-phpseclib & progress_bar $!;
	    	;;
	zypper)  
		zypper addrepo https://download.opensuse.org/repositories/home:ecsos:server/15.5/home:ecsos:server.repo
		zypper refresh
		"$package_manager" --non-interactive install php7 & progress_bar $!;
		"$package_manager" --non-interactive install php7-curl & progress_bar $!;
		"$package_manager" --non-interactive install php7-gd & progress_bar $!;
		"$package_manager" --non-interactive install php7-gmp & progress_bar $!;
		"$package_manager" --non-interactive install php7-bcmath & progress_bar $!;
		"$package_manager" --non-interactive install php7-intl & progress_bar $!; 
		"$package_manager" --non-interactive install php7-mbstring & progress_bar $!;
		"$package_manager" --non-interactive install php7-mysql & progress_bar $!;
		"$package_manager" --non-interactive install php7-ssh2 & progress_bar $!;
		"$package_manager" --non-interactive install php7-zip & progress_bar $!;
		"$package_manager" --non-interactive install php7-redis & progress_bar $!;
		"$package_manager" --non-interactive install php7-ldap & progress_bar $!;
		"$package_manager" --non-interactive install php7-phpseclib & progress_bar $!;
		zypper in apache2-mod_php7
		a2enmod php7
		systemctl restart apache2
		echo '<!DOCTYPE html>' | tee /srv/www/htdocs/index.html;
		echo '<html>' | tee -a /srv/www/htdocs/index.html;
		echo '<body>' | tee -a /srv/www/htdocs/index.html;
		echo '<h1>HTML TEST PAGE</h1>' | tee -a /srv/www/htdocs/index.html;
		echo '<p>PHP Info</p>' | tee -a /srv/www/htdocs/index.html;
		echo ' <a href="index.php">Click here for PHP Info</a> ' | tee -a /srv/www/htdocs/index.html;
		echo '</body>' | tee -a /srv/www/htdocs/index.html;
		echo '</html>' | tee -a /srv/www/htdocs/index.html;
		
		echo '<?php' | tee /srv/www/htdocs/index.php;
		echo 'phpinfo();' | tee -a /srv/www/htdocs/index.php;
		echo '?>' | tee -a /srv/www/htdocs/index.php;
		;;
	*) 	echo "Package manager error"
	   	;;
	esac
}




install_app () {
	 while true; do
	 	echo -e "\nDo you wish to install $1? "
   		read -p "Please answer (y)es or (n)o." yn
   	tput setaf $sdoutColor
      	case $yn in
        		[Yy]* ) 
        			
        			tput csr 8 $(($(tput lines) - 5))
			    	tput cup 8 0
			    	$1 
			    	
        			break;;
        		[Nn]* ) break;;
        		* ) echo "Please answer (y)es or (n)o.";;
    	esac
    	tput sgr0
	done
}

function progress_bar() { 
	pid=$1
 	((progress=1))
	while [ -e /proc/$pid ]; do
		kill -s STOP $pid > /dev/null 2>&1
		tput sc
	    	Rows=$(tput lines)
	    	Cols=$(tput cols)-2
	   	tput cup $(($Rows - 2)) 0
	    	((progress=progress+4))
	    	((remaining=${Cols}-${progress}))
	    	tput bold
	    	tput setaf $progressBarColorFG
	    	tput setab $progressBarColorBG
	    	echo -ne "[$(printf "%${progress}s" | tr " " "#")$(printf "%${remaining}s" | tr " " "-")]"
	    	tput cup $(($Rows - 1)) 0
      		tput sgr0
	    	tput ed
	    	if (( $progress > ($((Cols-4))) )); then
	   		((progress=1))
		fi
		tput rc
		sleep .5
		kill -s CONT $pid > /dev/null 2>&1
  		sleep 4
	done
}

function Header() { 
	tput bold
	tput setaf $headerColorFG
	tput setab $headerColorBG
	((ESpace=$(tput cols)-(${#installer_name})))
    	((LSide=((${ESpace}/2))-2))
    	((RSide=$(tput cols)-(${#installer_name})-${LSide}-4))
    	tput cup 0 0
    	echo -ne "[$(printf "%${LSide}s" | tr " " " ") $(printf "$installer_name") $(printf "%${RSide}s" | tr " " " ")]"
    	tput sgr0
    	echo -e ' '
}
function multiselect {
    # little helpers for terminal print control and key input
    ESC=$( printf "\033")
    cursor_blink_on()   { printf "$ESC[?25h"; }
    cursor_blink_off()  { printf "$ESC[?25l"; }
    cursor_to()         { printf "$ESC[$1;${2:-1}H"; }
    print_inactive()    { printf "$2   $1 "; }
    print_active()      { printf "$2  $ESC[7m $1 $ESC[27m"; }
    get_cursor_row()    { IFS=';' read -sdR -p $'\E[6n' ROW COL; echo ${ROW#*[}; }

    local return_value=$1
    local -n options=$2
    local -n defaults=$3

    local selected=()
    for ((i=0; i<${#options[@]}; i++)); do
        if [[ ${defaults[i]} = "true" ]]; then
            selected+=("true")
        else
            selected+=("false")
        fi
        printf "\n"
    done

    # determine current screen position for overwriting the options
    local lastrow=`get_cursor_row`
    local startrow=$(($lastrow - ${#options[@]}))

    # ensure cursor and input echoing back on upon a ctrl+c during read -s
    trap "cursor_blink_on; stty echo; printf '\n'; exit" 2
    cursor_blink_off

    key_input() {
        local key
        IFS= read -rsn1 key 2>/dev/null >&2
        if [[ $key = ""      ]]; then echo enter; fi;
        if [[ $key = $'\x20' ]]; then echo space; fi;
        if [[ $key = "k" ]]; then echo up; fi;
        if [[ $key = "j" ]]; then echo down; fi;
        if [[ $key = $'\x1b' ]]; then
            read -rsn2 key
            if [[ $key = [A || $key = k ]]; then echo up;    fi;
            if [[ $key = [B || $key = j ]]; then echo down;  fi;
        fi 
    }

    toggle_option() {
        local option=$1
        if [[ ${selected[option]} == true ]]; then
            selected[option]=false
        else
            selected[option]=true
        fi
    }

    print_options() {
        # print options by overwriting the last lines
        
        local idx=0
        for option in "${options[@]}"; do
            local prefix="[ ]"
            if [[ ${selected[idx]} == true ]]; then
              prefix="[\e[38;5;46m✔\e[0m]"
            fi

            cursor_to $(($startrow + $idx))
            if [ $idx -eq $1 ]; then
                print_active "$option" "$prefix"
            else
                print_inactive "$option" "$prefix"
            fi
            ((idx++))
        done
       
    	echo -e '\n'
	echo -e '\nPress enter when done with selections'
    }

    local active=0
    while true; do
        print_options $active

        # user key control
        case `key_input` in
            space)  toggle_option $active;;
            enter)  print_options -1; break;;
            up)     ((active--));
                    if [ $active -lt 0 ]; then active=$((${#options[@]} - 1)); fi;;
            down)   ((active++));
                    if [ $active -ge ${#options[@]} ]; then active=0; fi;;
        esac
    done
    
    # cursor position back to normal
    cursor_to $lastrow
    printf "\n"
    printf "\n"
    printf "\n"
    cursor_blink_on

    eval $return_value='("${selected[@]}")'
}

clear
TRows=$(tput lines)
TCols=$(tput cols)
if (( "80" > ${TCols} )); then
   	clear
   	Header
	echo -e ' '
      	echo "Terminal not wide enough ($TCols - columns)"
      	echo "Need 80 columns. Make terminal wider."
      	exit
fi
if (( "23" > ${TRows} )); then
   	clear
   	Header
	echo -e ' '
      	echo "Terminal not tall enough ($TRows - rows)"
      	echo "Need 23 rows. Make terminal taller."
      	exit
fi

systemctl stop Packagekit

if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
    VER=$VERSION_ID
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
    VER=$(lsb_release -sr)
elif [ -f /etc/lsb-release ]; then
    # For some versions of Debian/Ubuntu without lsb_release command
    . /etc/lsb-release
    OS=$DISTRIB_ID
    VER=$DISTRIB_RELEASE
elif [ -f /etc/debian_version ]; then
    # Older Debian/Ubuntu/etc.
    OS=Debian
    VER=$(cat /etc/debian_version)
elif [ -f /etc/SuSe-release ]; then
    # Older SuSE/etc.
    ...
elif [ -f /etc/redhat-release ]; then
    # Older Red Hat, CentOS, etc.
    ...
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    OS=$(uname -s)
    VER=$(uname -r)
fi
distro=$OS-$VER

Header
echo $distro
echo "Updating Packages...."
install_app Update
clear
Header
echo -e '\nArrow up/down space bar to select'
echo -e ' '
multiselect result my_options preselection

idx=0
for option in "${my_options[@]}"; do
   if [ "true" = "${result[idx]}" ]; then
   	clear
   	Header
	echo -e ' '
	echo "Installing.. $option"
      	install_app $option
      	echo -e ' '
      	tput sgr0
      	echo "Finished option.. $option"
      	read -p "Press enter to continue"
      	
   fi
    ((idx++))
done
clear
echo "Thank you for using $installer_name"
